const datesEl = document.getElementById("dates");
const monthGrid = document.getElementById("monthGrid");
const monthEl = document.getElementById("month");
const todayEl = document.getElementById("today");

const weeklyBtn = document.querySelector(".toggle button:nth-child(1)");
const monthlyBtn = document.querySelector(".toggle button:nth-child(2)");
const arcArea = document.querySelector(".arc-area");

const now = new Date();
const year = now.getFullYear();
const month = now.getMonth();
const today = now.getDate();

monthEl.textContent = now.toLocaleString("default",{month:"long"});
todayEl.textContent = today;

function loadWeekly(){
  datesEl.innerHTML="";
  arcArea.classList.remove("hidden");
  monthGrid.classList.add("hidden");

  const start = new Date(now);
  start.setDate(today - now.getDay());

  const offsets = [-10, 4, 15, 25, 15, 4, -10];

  for(let i=0;i<7;i++){
    const d = new Date(start);
    d.setDate(start.getDate() + i);

    const el = document.createElement("div");
    el.className = "date";
    el.textContent = d.getDate();
    el.style.transform = `translateY(${offsets[i]}px)`;

    if(
      d.getDate() === today &&
      d.getMonth() === month &&
      d.getFullYear() === year
    ){
      el.classList.add("active");
      el.style.transform = `translateY(${offsets[i] - 6}px)`;
    }

    datesEl.appendChild(el);
  }
}


function loadMonthly(){
  monthGrid.innerHTML="";
  arcArea.classList.add("hidden");
  monthGrid.classList.remove("hidden");

  const firstDay = new Date(year,month,1).getDay();
  const daysInMonth = new Date(year,month+1,0).getDate();

  for(let i=0;i<firstDay;i++){
    monthGrid.appendChild(document.createElement("div"));
  }

  for(let d=1; d<=daysInMonth; d++){
    const cell = document.createElement("div");
    cell.textContent=d;

    if(d===today){
      cell.classList.add("today");
    }

    monthGrid.appendChild(cell);
  }
}

weeklyBtn.onclick = ()=>{
  weeklyBtn.classList.add("active");
  monthlyBtn.classList.remove("active");
  loadWeekly();
};

monthlyBtn.onclick = ()=>{
  monthlyBtn.classList.add("active");
  weeklyBtn.classList.remove("active");
  loadMonthly();
};

loadWeekly();

document.querySelector(".setting").onclick = () => {
  alert("Setting clicked");
};

